📝 README – Présentation du Site Web
📌 Présentation générale

Ce projet est un site web léger et entièrement autonome, construit en HTML/CSS/JavaScript, qui fonctionne comme une Single Page Application (SPA) :
➡️ une seule page principale (index.html) affiche dynamiquement le contenu d’autres pages HTML, sans rechargement du site ni CSS/JS supplémentaires.

Le site inclut :

Une barre de navigation fixe et intelligente, qui apparaît et disparaît selon le scroll.

Un système de boutons/menu responsive.

Un mode plein écran activable/désactivable.

Un système de chargement de pages internes (SPA).

Un bouton retour en haut intégré dans la barre de navigation.

Un thème visuel élégant, basé sur une image de fond fixe.

🧱 Structure du projet
/
 ├─ index.html      → page principale (unique page réelle)
 ├─ style.css       → styles globaux, animations, responsive
 ├─ script.js       → barre dynamique, plein écran, SPA, hover, scroll
 ├─ images/         → icônes, logo, fond…
 ├─ page1/index.html → contenu chargé dynamiquement
 ├─ page2/index.html
 ├─ page3/index.html
 ├─ page4/index.html
 ├─ page5/index.html

⚙️ Fonctionnement détaillé
1. 🌐 Une vraie-fausse “Single Page Application”

L’utilisateur ne quitte jamais index.html.

Lorsqu’on clique sur Page 01, Page 02…, le JavaScript :

récupère la page (fetch())

lit son HTML

remplace dynamiquement le contenu de <div id="content">

Cela donne l’impression d’un site multi-pages, sans changement réel de page.

Ce système évite les rechargements et rend la navigation fluide.

2. 📌 Barre de navigation dynamique (scroll intelligent)

La barre :

disparaît quand on descend (gain de visibilité)

réapparaît dès qu’on remonte

reste en position fixed en haut de l’écran

s’affiche avec une transition fluide grâce à une classe .visible

Le script calcule :

la hauteur de la barre

l’offset nécessaire pour que le contenu ne soit pas caché

le sens du scroll

la vitesse du scroll (pour éviter les clignotements)

3. 🖱️ Icônes avec changement au survol

Toutes les images avec .change-on-hover :

changent de source au survol

changent aussi au focus (accessibilité renforcée)

reviennent à l’image d’origine en sortie

4. 🖥️ Mode plein écran

Le bouton plein écran :

active/désactive le Fullscreen API

change automatiquement l’icône selon l’état

fonctionne sur desktop et mobile (compatible navigateur moderne)

5. ⬆️ Bouton “Retour en haut”

Accessible dans la barre à droite :

scroll vertical doux (scrollTo({…, behavior:'smooth'}))

utile lorsqu’une page interne est longue

6. 🎨 Design & ergonomie
Image de fond fixe

L’effet « fond fixe » :

donne de la profondeur

assure un design moderne

reste centré et couvre tout l’écran (cover fixed)

Menus élégants

boutons ombrés

hover avec effet d’élévation

couleurs sobres + jaune vif pour les éléments actifs

responsive grâce à clamp()

Contenu centré

Les blocs d’articles ont :

transparence

ombres

coins arrondis

mise en page aérée

⭐ Points forts
✔ 1. Site très rapide

Aucun rechargement de page :
➡ chargement instantané des sections
➡ ressources partagées (CSS et JS uniques)

✔ 2. Code clair et bien structuré

CSS organisé par grandes sections

JS encapsulé dans une IIFE (pas de variables globales)

Animations légères et propres

Excellent usage de requestAnimationFrame pour le scroll

✔ 3. Très bonne ergonomie

navigation fluide

bouton haut de page intégré

mode plein écran fonctionnel

menus visibles et réactifs

✔ 4. Design esthétique

fond fixe

transparence

ombres

police élégante

✔ 5. Facile à personnaliser

on peut ajouter autant de pages HTML que voulu

le menu supérieur peut être modifié facilement

thème graphique simple à adapter

❌ Points faibles / limitations
✖ 1. Le fonctionnement SPA reste basique

pas de gestion d’historique (bouton retour du navigateur ne change pas de page)

pas de transitions entre les pages chargées

pas de système d’erreur avancé en cas d’échec du fetch

✖ 2. Les pages internes doivent être sans <html>, <head>, CSS ou JS

Obligation pour fonctionner correctement avec innerHTML.

✖ 3. Problèmes possibles sur certains serveurs

certains serveurs refusent fetch() en local (CORS)

nécessite souvent d’utiliser un serveur local simple (Live Server)

✖ 4. Code non optimisé pour très grandes applications

pas de routage

pas de programmation modulaire (pas encore de composants)

pas de framework (Vue/React…), donc certaines fonctionnalités demandent plus de code

🚀 Améliorations possibles

Voici quelques idées d’évolution :

Ajouter une gestion de l’historique (window.history.pushState)

Ajouter des animations de transition lors du changement de contenu

Mettre en place un système de templates plus avancé

Charger les pages en cache pour accélérer encore

Ajouter un loader animé pendant le fetch

Ajouter un dark mode automatique

📄 Licence

Projet libre d’utilisation et de modification.
Tu peux adapter, étendre ou reprendre librement le code.